# Copyright (C) 2020 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause

from PySide6.QtCore import Qt, Slot
from PySide6.QtWidgets import QDialog, QHeaderView, QTableWidgetItem
from PySide6.QtCoap import QCoapOption

from ui_optiondialog import Ui_OptionDialog as ui


class OptionDialog(QDialog):
    def __init__(self, parent=None):
        super(OptionDialog, self).__init__(parent)
        self._ui = ui()
        self._ui.setupUi(self)
        self._options = []

        self.fillOptions()

        header = self._ui.tableWidget.horizontalHeader()
        header.setSectionResizeMode(QHeaderView.ResizeMode.Stretch)

    def options(self):
        return self._options

    @Slot()
    def on_addButton_clicked(self):
        data = self._ui.optionComboBox.currentData(Qt.ItemDataRole.UserRole)
        option = QCoapOption.OptionName(data)
        self._options.append(QCoapOption(option, self._ui.optionValueEdit.text()))

        rowCount = self._ui.tableWidget.rowCount()
        self._ui.tableWidget.insertRow(rowCount)

        optionItem = QTableWidgetItem(self._ui.optionComboBox.currentText())
        optionItem.setFlags(optionItem.flags() ^ Qt.ItemFlag.ItemIsEditable)
        self._ui.tableWidget.setItem(rowCount, 0, optionItem)

        valueItem = QTableWidgetItem(self._ui.optionValueEdit.text())
        valueItem.setFlags(valueItem.flags() ^ Qt.ItemFlag.ItemIsEditable)
        self._ui.tableWidget.setItem(rowCount, 1, valueItem)

    @Slot()
    def on_clearButton_clicked(self):
        self._options.clear()
        self._ui.tableWidget.setRowCount(0)

    def fillOptions(self):
        self._ui.tableWidget.setHorizontalHeaderLabels({"Name", "Value"})
        self._ui.optionComboBox.addItem("None", QCoapOption.OptionName.Invalid)
        self._ui.optionComboBox.addItem("Block1", QCoapOption.OptionName.Block1)
        self._ui.optionComboBox.addItem("Block2", QCoapOption.OptionName.Block2)
        self._ui.optionComboBox.addItem("Content-Format", QCoapOption.OptionName.ContentFormat)
        self._ui.optionComboBox.addItem("If-Match", QCoapOption.OptionName.IfMatch)
        self._ui.optionComboBox.addItem("If-None-Match", QCoapOption.OptionName.IfNoneMatch)
        self._ui.optionComboBox.addItem("Location-Path", QCoapOption.OptionName.LocationPath)
        self._ui.optionComboBox.addItem("Location-Query", QCoapOption.OptionName.LocationQuery)
        self._ui.optionComboBox.addItem("Max-Age", QCoapOption.OptionName.MaxAge)
        self._ui.optionComboBox.addItem("Observe", QCoapOption.OptionName.Observe)
        self._ui.optionComboBox.addItem("Proxy-Scheme", QCoapOption.OptionName.ProxyScheme)
        self._ui.optionComboBox.addItem("Proxy-Uri", QCoapOption.OptionName.ProxyUri)
        self._ui.optionComboBox.addItem("Size1", QCoapOption.OptionName.Size1)
        self._ui.optionComboBox.addItem("Size2", QCoapOption.OptionName.Size2)
        self._ui.optionComboBox.addItem("Uri-Host", QCoapOption.OptionName.UriHost)
        self._ui.optionComboBox.addItem("Uri-Path", QCoapOption.OptionName.UriPath)
        self._ui.optionComboBox.addItem("Uri-Port", QCoapOption.OptionName.UriPort)
        self._ui.optionComboBox.addItem("Uri-Query", QCoapOption.OptionName.UriQuery)
